<?php $__env->startSection('admin_content'); ?>
<style>
    div#DataTables_Table_0_wrapper .btn {
    padding: 0 1.5rem;
    margin: 9px !important;
}
</style>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header pb-0">
                        <h4 class="card-title">
                            <div class="d-flex justify-content-between">
                                <div><?php echo e($title); ?> Payment Lists</div>
                            </div>
                        </h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body card-dashboard">
                            <div class="table-responsive">
                                <table class="table table-striped dataex-html5-selectors">
                                    <thead>
                                    <tr>
                                        <th>S.N</th>
                                        <th>User Info</th>
                                        <th>Payment Info</th>
                                        <th>photo</th>
                                        <th>Payment Amounts</th>
                                        <th>Status</th>
                                        <th>Active</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td>
                                                <small>
                                                    Username: <?php echo e($row->user->username ?? '--'); ?>  <br>
                                                    Ref_id: <?php echo e($row->user->ref_id ?? '--'); ?> <br>
                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Method Name: <?php echo e($row->method_name); ?> <br>
                                                    Date : <?php echo e($row->date); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(asset($row->photo)); ?>" >
                                                    <img src="<?php echo e(asset($row->photo)); ?>" style="width: 100px" alt="">
                                                </a>
                                            </td>
                                            <td>
                                                <small>
                                                    Number: <?php echo e($row->number); ?><br>
                                                    Transaction ID: <strong><?php echo e($row->transaction_id); ?></strong><br>
                                                    Added Amount : <?php echo e(number_format($row->final_amount, 2)); ?>

                                                </small>
                                            </td>
                                            <td>
                                                <small>
                                                    Status: <span class="badge <?php if($row->status == 'pending'): ?> badge-warning <?php elseif($row->status == 'approved'): ?> badge-success  <?php elseif($row->status == 'rejected'): ?> badge-danger <?php endif; ?>" style="font-size: 8px"><?php echo e($row->status); ?></span> <br>
                                                </small>
                                            </td>
                                            <td>
                                                <?php if($row->status == 'approved'): ?>
                                                    <span style="color: green">Payment Approved</span>
                                                <?php elseif($row->status == 'pending'): ?>
                                                    <a href="<?php echo e(route('payment.status.change.approved', $row->id)); ?>" class="btn btn-success">Approved</a>
                                                    <a href="<?php echo e(route('payment.status.change.rejected', $row->id)); ?>" class="btn btn-danger">Rejected</a>
                                                <?php elseif($row->status == 'rejected'): ?>
                                                    <span style="color: red">Payment Rejected</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/evboxmoz/bitcoinminor.xyz/v4/resources/views/admin/pages/payment/list.blade.php ENDPATH**/ ?>