<?php $__env->startSection('admin_content'); ?>
    <section id="dashboard-ecommerce">
        <div class="row">
            <div class="col-12">
                <form action="<?php echo e(route('admin.bonus.insert')); ?>" method="POST" enctype="multipart/form-data"><?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($data ? $data->id : ''); ?>">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div><?php echo e($data ? 'Update' : 'Create New'); ?> Bonus</div>
                                    <div>
                                        <a href="<?php echo e(route('admin.bonus.index')); ?>" class="btn btn-primary btn-sm"> <i
                                                class="bx bx-left-arrow"></i> Bonus List</a>
                                    </div>
                                </div>
                            </h4>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="bonus_name">Bonus Name</label>
                                        <input type="text" class="form-control is-valid"
                                               name="bonus_name" id="bonus_name"
                                               placeholder="Bonus name" value="<?php echo e($data ? $data->bonus_name : old('bonus_name')); ?>" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This is filed is required
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <label for="set_service_counter">Set service counter</label>
                                        <input type="number" class="form-control is-valid"
                                               name="set_service_counter" id="set_service_counter"
                                               placeholder="Set service counter" value="<?php echo e($data ? $data->set_service_counter : old('set_service_counter')); ?>" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This is filed is required
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="price">Code <small>Ex:Ex:TB-0000001 </small> </label>
                                        <input type="text" class="form-control is-valid"
                                               name="code" id="price"
                                               placeholder="Ex:TB-0000001" value="<?php echo e($data ? $data->code : old('code')); ?>" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This is filed is required
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="winner">Winner(Get Got Person Counter)</label>
                                        <input type="text" class="form-control is-valid"
                                               name="winner" id="winner"
                                               placeholder="Listen: 0 to 7" value="<?php echo e($data ? $data->winner : old('winner')); ?>" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This is filed is required
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <label for="amount">Amount Note: 1 to random get amount</label>
                                        <input type="number" class="form-control is-valid"
                                               name="amount" id="amount"
                                               placeholder="Amount" value="<?php echo e($data ? $data->amount : old('amount')); ?>" required>
                                        <div class="valid-feedback">
                                            <i class="bx bx-radio-circle"></i>
                                            Note: This is filed is required
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Form Submit Button -->
                    <div class="card">
                        <div class="card-header">
                            <h6 class="card-title">
                                <div class="d-flex justify-content-between">
                                    <div style="margin-top: .7rem !important">
                                        Submit Your Bonus Information
                                    </div>
                                    <div>
                                        <div class="form-group mb-0">
                                            <button type="submit" class="btn btn-success"><i
                                                    class="bx bx-plus"></i><?php echo e($data ? 'Update' : 'Submit'); ?> </button>
                                        </div>
                                    </div>
                                </div>
                            </h6>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
    <script>
        function showPreview(event){
            if(event.target.files.length > 0){
                var src = URL.createObjectURL(event.target.files[0]);
                var preview = document.getElementById("file-ip-1-preview");
                preview.src = src;
                preview.style.display = "block";
            }
        }
        function calculateHour(_this){
            document.getElementById('hours').value = _this.value * 24
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/evboxmoz/bitcoinminor.xyz/v4/resources/views/admin/pages/bonus/insert.blade.php ENDPATH**/ ?>